/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.VarNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.graalvm.collections.EconomicMap;

public final class Scope {
    private final Scope parent;
    private final int type;
    private final int flags;
    private static final int BLOCK_SCOPE = 1;
    private static final int FUNCTION_BODY_SCOPE = 2;
    private static final int FUNCTION_PARAMETER_SCOPE = 4;
    private static final int CATCH_PARAMETER_SCOPE = 8;
    private static final int GLOBAL_SCOPE = 16;
    private static final int MODULE_SCOPE = 32;
    private static final int FUNCTION_TOP_SCOPE = 64;
    private static final int SWITCH_BLOCK_SCOPE = 128;
    private static final int CLASS_SCOPE = 256;
    private static final int EVAL_SCOPE = 512;
    private static final int IN_FUNCTION = 65536;
    private static final int IN_METHOD = 131072;
    private static final int IN_DERIVED_CONSTRUCTOR = 262144;
    private static final int IS_CLASS_FIELD_INITIALIZER = 524288;
    protected final EconomicMap<String, Symbol> symbols;
    protected List<Map.Entry<VarNode, Scope>> hoistedVarDeclarations;
    protected List<Map.Entry<VarNode, Scope>> hoistableBlockFunctionDeclarations;
    private int blockScopedOrRedeclaredSymbols;
    private int declaredNames;
    private boolean closed;

    private Scope(Scope parent, int type, int flags) {
        this.parent = parent;
        this.type = type | (Scope.isFunctionTopScope(type, parent) ? 64 : 0);
        this.symbols = EconomicMap.create();
        this.flags = flags;
    }

    private Scope(Scope parent, int type) {
        this(parent, type, parent == null ? 0 : parent.flags);
    }

    private static boolean isFunctionTopScope(int type, Scope parent) {
        return (type & 4) != 0 || (type & 2) != 0 && (parent == null || !parent.isFunctionParameterScope());
    }

    private static int computeFlags(Scope parent, int functionFlags) {
        if ((functionFlags & 0x10000) != 0) {
            return parent.flags;
        }
        int flags = 0;
        flags |= 0x10000;
        flags |= (functionFlags & 0x100000) != 0 ? 131072 : 0;
        flags |= (functionFlags & 0x400000) != 0 ? 262144 : 0;
        return flags |= (functionFlags & 0x40000000) != 0 ? 524288 : 0;
    }

    public static Scope createGlobal() {
        return new Scope(null, 18);
    }

    public static Scope createModule() {
        return new Scope(null, 34);
    }

    public static Scope createFunctionBody(Scope parent, int functionFlags) {
        return new Scope(parent, 2, Scope.computeFlags(parent, functionFlags));
    }

    public static Scope createBlock(Scope parent) {
        return new Scope(parent, 1);
    }

    public static Scope createCatch(Scope parent) {
        return new Scope(parent, 8);
    }

    public static Scope createParameter(Scope parent, int functionFlags) {
        return new Scope(parent, 4, Scope.computeFlags(parent, functionFlags));
    }

    public static Scope createSwitchBlock(Scope parent) {
        return new Scope(parent, 129);
    }

    public static Scope createClass(Scope parent) {
        return new Scope(parent, 257);
    }

    public static Scope createEval(Scope parent, boolean strict) {
        return new Scope(parent, 0x200 | (strict ? 2 : 0));
    }

    public Scope getParent() {
        return this.parent;
    }

    public Iterable<Symbol> getSymbols() {
        return this.symbols.getValues();
    }

    public Symbol getExistingSymbol(String name) {
        return (Symbol)this.symbols.get((Object)name);
    }

    public boolean hasSymbol(String name) {
        return this.symbols.containsKey((Object)name);
    }

    public int getSymbolCount() {
        return this.symbols.size();
    }

    public Symbol putSymbol(Symbol symbol) {
        assert (!this.closed) : "scope is closed";
        Symbol existing = (Symbol)this.symbols.put((Object)symbol.getName(), (Object)symbol);
        if (existing != null) {
            assert ((existing.getFlags() & 7) == (symbol.getFlags() & 7)) : symbol;
            return existing;
        }
        if (symbol.isBlockScoped() || symbol.isVarRedeclaredHere()) {
            ++this.blockScopedOrRedeclaredSymbols;
        }
        if (symbol.isBlockScoped() || symbol.isVar() && !symbol.isParam()) {
            ++this.declaredNames;
        }
        return null;
    }

    public boolean hasBlockScopedOrRedeclaredSymbols() {
        return this.blockScopedOrRedeclaredSymbols != 0;
    }

    public boolean hasDeclarations() {
        return this.declaredNames != 0;
    }

    public boolean isLexicallyDeclaredName(String varName, boolean annexB, boolean includeParameters) {
        for (Scope current = this; current != null; current = current.getParent()) {
            Symbol existingSymbol = current.getExistingSymbol(varName);
            if (existingSymbol != null && existingSymbol.isBlockScoped()) {
                if (existingSymbol.isCatchParameter() && annexB) continue;
                return true;
            }
            if (includeParameters ? current.isFunctionTopScope() : current.isFunctionBodyScope()) break;
        }
        return false;
    }

    public Symbol findBlockScopedSymbolInFunction(String varName) {
        for (Scope current = this; current != null; current = current.getParent()) {
            Symbol existingSymbol = current.getExistingSymbol(varName);
            if (existingSymbol != null) {
                if (!existingSymbol.isBlockScoped()) break;
                return existingSymbol;
            }
            if (current.isFunctionTopScope()) break;
        }
        return null;
    }

    public void recordHoistedVarDeclaration(VarNode varDecl, Scope scope) {
        assert (!varDecl.isBlockScoped());
        if (this.hoistedVarDeclarations == null) {
            this.hoistedVarDeclarations = new ArrayList<Map.Entry<VarNode, Scope>>();
        }
        this.hoistedVarDeclarations.add(new AbstractMap.SimpleImmutableEntry<VarNode, Scope>(varDecl, scope));
    }

    public VarNode verifyHoistedVarDeclarations() {
        if (!this.hasHoistedVarDeclarations()) {
            return null;
        }
        for (Map.Entry<VarNode, Scope> entry : this.hoistedVarDeclarations) {
            VarNode varDecl = entry.getKey();
            Scope declScope = entry.getValue();
            String varName = varDecl.getName().getName();
            for (Scope current = declScope; current != this; current = current.getParent()) {
                Symbol existing = current.getExistingSymbol(varName);
                if (existing == null || !existing.isBlockScoped() || existing.isCatchParameter()) continue;
                return varDecl;
            }
        }
        return null;
    }

    public boolean hasHoistedVarDeclarations() {
        return this.hoistedVarDeclarations != null;
    }

    public void recordHoistableBlockFunctionDeclaration(VarNode functionDeclaration, Scope scope) {
        assert (functionDeclaration.isFunctionDeclaration() && functionDeclaration.isBlockScoped());
        if (this.hoistableBlockFunctionDeclarations == null) {
            this.hoistableBlockFunctionDeclarations = new ArrayList<Map.Entry<VarNode, Scope>>();
        }
        this.hoistableBlockFunctionDeclarations.add(new AbstractMap.SimpleImmutableEntry<VarNode, Scope>(functionDeclaration, scope));
    }

    public void declareHoistedBlockFunctionDeclarations() {
        if (this.hoistableBlockFunctionDeclarations == null) {
            return;
        }
        block0: for (Map.Entry<VarNode, Scope> entry : this.hoistableBlockFunctionDeclarations) {
            VarNode functionDecl = entry.getKey();
            Scope functionDeclScope = entry.getValue();
            String varName = functionDecl.getName().getName();
            for (Scope current = functionDeclScope.getParent(); current != null; current = current.getParent()) {
                Symbol existing = current.getExistingSymbol(varName);
                if (existing != null && existing.isBlockScoped() && !existing.isCatchParameter()) continue block0;
                if (current.isFunctionBodyScope()) break;
            }
            if (this.getExistingSymbol(varName) == null) {
                this.putSymbol(new Symbol(varName, 4 | (this.isGlobalScope() ? 8 : 0)));
            }
            functionDeclScope.getExistingSymbol(varName).setHoistedBlockFunctionDeclaration();
        }
    }

    public boolean addPrivateName(String name, int symbolFlags) {
        assert (this.isClassScope());
        if (this.hasSymbol(name)) {
            assert (this.getExistingSymbol(name).isPrivateName());
            return false;
        }
        this.putSymbol(new Symbol(name, 0x20402 | symbolFlags));
        return true;
    }

    public boolean findPrivateName(String name) {
        Scope current = this;
        while (current != null) {
            if (current.hasSymbol(name)) {
                return true;
            }
            current = current.parent;
        }
        return false;
    }

    public boolean isBlockScope() {
        return (this.type & 1) != 0;
    }

    public boolean isFunctionBodyScope() {
        return (this.type & 2) != 0;
    }

    public boolean isFunctionParameterScope() {
        return (this.type & 4) != 0;
    }

    public boolean isCatchParameterScope() {
        return (this.type & 8) != 0;
    }

    public boolean isGlobalScope() {
        return (this.type & 0x10) != 0;
    }

    public boolean isModuleScope() {
        return (this.type & 0x20) != 0;
    }

    public boolean isFunctionTopScope() {
        return (this.type & 0x40) != 0;
    }

    public boolean isSwitchBlockScope() {
        return (this.type & 0x80) != 0;
    }

    public boolean isClassScope() {
        return (this.type & 0x100) != 0;
    }

    public boolean isEvalScope() {
        return (this.type & 0x200) != 0;
    }

    public boolean inFunction() {
        return (this.flags & 0x10000) != 0;
    }

    public boolean inMethod() {
        return (this.flags & 0x20000) != 0;
    }

    public boolean inDerivedConstructor() {
        return (this.flags & 0x40000) != 0;
    }

    public boolean inClassFieldInitializer() {
        return (this.flags & 0x80000) != 0;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.hoistableBlockFunctionDeclarations != null) {
            this.declareHoistedBlockFunctionDeclarations();
        }
        this.closed = true;
    }

    public String toString() {
        StringJoiner names = new StringJoiner(",", "(", ")");
        for (String name : this.symbols.getKeys()) {
            names.add(name);
        }
        return "[" + this.getScopeKindName() + "Scope" + names + (this.parent == null ? "" : ", " + this.parent + "") + "]";
    }

    private String getScopeKindName() {
        if (this.isGlobalScope()) {
            return "Global";
        }
        if (this.isModuleScope()) {
            return "Module";
        }
        if (this.isFunctionBodyScope()) {
            return "Var";
        }
        if (this.isFunctionParameterScope()) {
            return "Param";
        }
        if (this.isCatchParameterScope()) {
            return "Catch";
        }
        if (this.isSwitchBlockScope()) {
            return "Switch";
        }
        if (this.isClassScope()) {
            return "Class";
        }
        if (this.isEvalScope()) {
            return "Eval";
        }
        return "";
    }
}

